{{-- resources/views/admin/users/show.blade.php --}}
@extends('layouts.admin')

@section('content')
<div class="users-management">
    <div class="users-header">
        <h1>User Details</h1>
        <div class="users-actions">
            <a href="{{ route('admin.users.edit', $user) }}" class="btn btn-primary">
                <i class="fas fa-edit"></i> Edit User
            </a>
            <a href="{{ route('admin.users.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Users
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4">
            <div class="dashboard-card">
                <div class="dashboard-card-header">
                    <h3>User Profile</h3>
                </div>
                <div class="dashboard-card-body">
                    <div class="text-center mb-4">
                        <img src="{{ $user->avatar }}" alt="{{ $user->name }}" style="width: 150px; height: 150px; border-radius: 50%;">
                        <h2 class="mt-3">{{ $user->name }}</h2>
                        <div class="mt-2">
                            @forelse($user->roles as $role)
                                <span class="user-role {{ strtolower($role->name) == 'admin' ? 'role-admin' : (strtolower($role->name) == 'moderator' ? 'role-moderator' : 'role-user') }}">
                                    {{ $role->name }}
                                </span>
                            @empty
                                <span class="user-role role-user">User</span>
                            @endforelse
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table">
                            <tbody>
                                <tr>
                                    <th>Steam ID:</th>
                                    <td>
                                        <a href="{{ $user->getSteamProfileUrl() }}" target="_blank" class="steam-link">
                                            {{ $user->steamid }}
                                            <i class="fas fa-external-link-alt ml-1"></i>
                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Slug:</th>
                                    <td>{{ $user->slug }}</td>
                                </tr>
                                <tr>
                                    <th>Last Active:</th>
                                    <td>{{ $user->last_active_at ? $user->last_active_at->format('M d, Y H:i') : 'Never' }}</td>
                                </tr>
                                <tr>
                                    <th>Registered:</th>
                                    <td>{{ $user->created_at->format('M d, Y H:i') }}</td>
                                </tr>
                                <tr>
                                    <th>Updated:</th>
                                    <td>{{ $user->updated_at->format('M d, Y H:i') }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="dashboard-card">
                <div class="dashboard-card-header">
                    <h3>Permissions</h3>
                </div>
                <div class="dashboard-card-body">
                    <div class="mb-3">
                        <h4>Roles</h4>
                        <div class="d-flex flex-wrap gap-2">
                            @forelse($user->roles as $role)
                                <span class="user-role {{ strtolower($role->name) == 'admin' ? 'role-admin' : (strtolower($role->name) == 'moderator' ? 'role-moderator' : 'role-user') }}">
                                    {{ $role->name }}
                                </span>
                            @empty
                                <p>No roles assigned</p>
                            @endforelse
                        </div>
                    </div>

                    <div>
                        <h4>Direct Permissions</h4>
                        <div class="d-flex flex-wrap gap-2">
                            @forelse($user->getDirectPermissions() as $permission)
                                <span class="user-role">{{ $permission->name }}</span>
                            @empty
                                <p>No direct permissions</p>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="dashboard-card">
                <div class="dashboard-card-header d-flex justify-content-between align-items-center">
                    <h3>Actions</h3>
                </div>
                <div class="dashboard-card-body">
                    <div class="d-flex flex-wrap gap-3">
                        <a href="{{ route('admin.users.edit', $user) }}" class="btn btn-primary">
                            <i class="fas fa-edit"></i> Edit User
                        </a>
                        @if(auth()->id() !== $user->id)
                            <form action="{{ route('admin.users.destroy', $user) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this user?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">
                                    <i class="fas fa-trash"></i> Delete User
                                </button>
                            </form>
                        @endif
                        <a href="{{ $user->getSteamProfileUrl() }}" target="_blank" class="btn btn-secondary">
                            <i class="fab fa-steam"></i> View Steam Profile
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection